<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);
// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {

    // Acceder a los valores individuales de los datos combinados
	$codigo = $data['codigo'];
    $codigoSunat = $data['codigo_sunat'];
    $codigoAlmacen = $data['codigo_almacen'];
    $grupo = $data['grupo'];
    $familia = $data['familia'];
    $categoria = $data['categoria'];
    $producto = $data['producto'];
    $descripcion = $data['descripcion'];
    $lote = $data['lote'];
    $stok = $data['stok'];
    $p_unit = $data['p_unit'];
    $p_venta = $data['p_venta'];
    $p_venta_x_mayor = $data['p_venta_x_mayor'];
    $precio_mayor2 = $data['precio_mayor2'];
    $igv1 = $data['igv1'];
    $igv_si_no = $data['igv_si_no'];
    $gratuito = $data['gratuito'];
    $fecha_emision = $data['fecha_emision'];
    $fecha_vence = $data['fecha_vence'];
    $estado = $data['estado'];
    $unidad_medida = $data['unidad_medida'];
    $foto = $data['foto'];
    $equivalencias = $data['equivalencias']; // Agregado: Obtener datos de equivalencias
    $sucursales = $data['sucursales'];

    // Ejemplo de inserción en la tabla productos
    $queryProductos = "INSERT INTO productos (codigo, codigo_sunat, codigo_almacen, grupo,familia, categoria, producto, descripcion, lote, stok, p_unit, p_venta, p_venta_x_mayor, precio_mayor2, igv1, igv_si_no, gratuito, fecha_emision, fecha_vence, estado, unidad_medida, foto) 
    VALUES ('$codigo', '$codigoSunat', '$codigoAlmacen', '$grupo','$familia', '$categoria', '$producto', '$descripcion', '$lote', '$stok', '$p_unit', '$p_venta', '$p_venta_x_mayor', '$precio_mayor2', '$igv1', '$igv_si_no', '$gratuito', '$fecha_emision', '$fecha_vence', '$estado', '$unidad_medida', '$foto')";
    $resultadoProductos = mysqli_query($conn, $queryProductos);
    if (!$resultadoProductos) {
        throw new Exception(mysqli_error($conn));
    }

    // Obtener el ID del último registro insertado en la tabla productos
    $idProducto = mysqli_insert_id($conn);

    // Ejemplo de inserción en la tabla equivalencias
    foreach ($equivalencias as $equivalencia) {
        $cod_producto = $codigo; // Usar el mismo código generado para las equivalencias
        $cod_unidad_medida = $equivalencia['cod_unidad_medida'];
        $equivalencia_valor = $equivalencia['equivalencia']; //
        $stock = $equivalencia['stock'];
        $precio_x_menor = $equivalencia['precio_x_menor'];
        $precio_x_mayor = $equivalencia['precio_x_mayor'];
        $precio_mayor2_equivalencia = $equivalencia['precio_mayor2']; // 

        $queryEquivalencias = "INSERT INTO articulo_x_unidad_medida (cod_producto, cod_unidad_medida, equivalencia, stock, precio_x_menor, precio_x_mayor, precio_mayor2) 
        VALUES ('$cod_producto', '$cod_unidad_medida', '$equivalencia_valor', '$stock', '$precio_x_menor', '$precio_x_mayor', '$precio_mayor2_equivalencia')";
        $resultadoEquivalencias = mysqli_query($conn, $queryEquivalencias);

        if (!$resultadoEquivalencias) {
            throw new Exception(mysqli_error($conn));
        }
    }

    // Ejemplo de inserción en la tabla productos_sucursales
    foreach ($sucursales as $sucursal) {
        $producto_id = $idProducto;
        $sucursal_id = $sucursal['sucursal_id'];
        $stock = $sucursal['stock'];

        $queryProductosSucursales = "INSERT INTO productos_sucursales (producto_id, sucursal_id, stock) 
        VALUES ('$producto_id', '$sucursal_id', '$stock')";
        $resultadoProductosSucursales = mysqli_query($conn, $queryProductosSucursales);

        if (!$resultadoProductosSucursales) {
            throw new Exception(mysqli_error($conn));
        }
    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>
