<?php
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $data = json_decode(file_get_contents("php://input"), true);
    if (!isset($data['detalle_id']) || !isset($data['elegir'])) {
        throw new Exception("Faltan datos requeridos.");
    }

    $stmt = $conn->prepare("UPDATE detcobranza SET elegir = :elegir WHERE id = :detalle_id");
    $stmt->execute([
        ':elegir' => filter_var($data['elegir'], FILTER_VALIDATE_BOOLEAN),
        ':detalle_id' => $data['detalle_id']
    ]);

    echo json_encode([
        "ESTADO" => "1",
        "MENSAJE" => "Campo 'elegir' actualizado correctamente"
    ]);

} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "Error: " . $e->getMessage()
    ]);
} finally {
    $conn = null;
}
