<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // 1. Leer la entrada cruda
    $bodyRequest = file_get_contents("php://input");

    // 2. Decodificar el JSON
    $datos = json_decode($bodyRequest, true);

    // 3. Validación
    if (!isset($datos['idcliente']) || !is_numeric($datos['idcliente'])) {
        throw new Exception("ID de cliente inválido o no enviado.");
    }

    $clienteId = (int) $datos['idcliente'];

    // 4. Ejecutar función PostgreSQL
    $sql = "SELECT * FROM consultar_ventas_clteid(:clienteId)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':clienteId', $clienteId, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "estado" => "00",
        "mensaje" => "OK",
        "data" => $rows
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "error" => "Error en la API",
        "mensaje" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}