<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 2) {
        throw new Exception("Parámetros inválidos. Se requieren empresa_id y nombre.");
    }

    $empresaId = $datos[0];
    $nombre = $datos[1];

    $sql = "SELECT nombre FROM conductor WHERE empresa_id = :empresa_id AND nombre = :nombre LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id', $empresaId, PDO::PARAM_INT);
    $stmt->bindValue(':nombre', $nombre, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    print_json($rows);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'ERROR: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH: echo ' - Maximum stack depth exceeded'; break;
        case JSON_ERROR_STATE_MISMATCH: echo ' - Underflow or the modes mismatch'; break;
        case JSON_ERROR_CTRL_CHAR: echo ' - Unexpected control character found'; break;
        case JSON_ERROR_SYNTAX: echo ' - Syntax error, malformed JSON'; break;
        case JSON_ERROR_UTF8: echo ' - Malformed UTF-8 characters'; break;
        default: echo ' - Unknown error'; break;
    }
}
?>
