<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $json = json_decode(file_get_contents("php://input"), true);

    if (!$json || !isset($json['detalle'])) {
        throw new Exception("Parámetro 'detalle' no proporcionado.");
    }

    $stmt = $conn->prepare("SELECT im_contometro(
        :surtidor_id, :cara, :manguera, :producto, :combustible, :total_galones,
        :total_monto, :turno_id, :usuario_id, :empresa_id, :sucursal_id
    )");
    
    foreach ($json['detalle'] as $fila) {
        $stmt->execute([
            ':surtidor_id' => $fila['surtidor_id'],
            ':cara' => $fila['cara'],
            ':manguera' => $fila['manguera'],
            ':producto' => $fila['producto'],
            ':combustible' => $fila['combustible'],
            ':total_galones' => $fila['total_galones'],
            ':total_monto' => $fila['total_monto'],
            ':turno_id' => $fila['turno_id'],
            ':usuario_id' => $fila['usuario_id'],
            ':empresa_id' => $fila['empresa_id'],
            ':sucursal_id' => $fila['sucursal_id']
        ]);
    }

    echo json_encode(['estado' => '1', 'mensaje' => 'Registros guardados correctamente.']);

} catch (Exception $e) {
    echo json_encode(['estado' => '0', 'mensaje' => $e->getMessage()]);
}
?>
