<?php
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $placa = trim($input['placa'] ?? '');

    if ($placa === '') {
        throw new Exception("Placa no proporcionada");
    }

    $stmt = $conn->prepare("SELECT c.id, c.nombre, c.documento_identidad, c.direccion
                            FROM placa_cliente p
                            JOIN clientes c ON c.id = p.cliente_id
                            WHERE p.placa = :placa
                            LIMIT 1");
    $stmt->execute([':placa' => $placa]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cliente) {
        echo json_encode(["ESTADO" => "OK", "DATA" => $cliente]);
    } else {
        echo json_encode(["ESTADO" => "ERROR", "MENSAJE" => "Cliente no encontrado"]);
    }

} catch (Exception $e) {
    echo json_encode(["ESTADO" => "ERROR", "MENSAJE" => $e->getMessage()]);
}
