<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros incompletos.");
    }

    $sql = "SELECT * FROM verifica_turno_abierto(:usuario_id, :empresa_id, :sucursal_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':usuario_id' => (int)$datos[0],
        ':empresa_id' => (int)$datos[1],
        ':sucursal_id' => (int)$datos[2]
    ]);

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && isset($row['id'])) {
        echo json_encode([
            "ESTADO" => "1",
            "ID_TURNO" => $row['id'],
            "NOMBRE_TURNO" => $row['nombre_turno'],
            "data" => [$row]
        ]);
    } else {
        echo json_encode([
            "ESTADO" => "0",
            "MENSAJE" => "No hay turno abierto para este usuario.",
            "data" => []
        ]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'ESTADO' => 'ERROR',
        'MENSAJE' => $e->getMessage()
    ]);
    // echo json_encode([]); // también como array vacío para que Java no falle
} finally {
    unset($stmt);
    $conn = null;
}
