<?php
header('Content-Type: application/json; charset=utf-8');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $sql = "SELECT * FROM controlador.verificar_max_id_despacho()";
    $stmt = $conn->prepare($sql);
    $stmt->execute();

    $fila = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        "ESTADO" => "1",
        "max_id" => $fila['max_id']
    ]);
} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ]);
}
