<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 15) {
        throw new Exception("Datos incompletos");
    }

    $sql = "SELECT im_empleado(
        :tipo_doc, :doc_identidad, :nombre, :direccion, :ubigeo,
        :distrito, :provincia, :region, :email, :perfil,
        :telefono, :empresa_id, :sucursal_id, :id_empleado, :estado
    ) AS id_empleado";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':tipo_doc', $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':doc_identidad', $datos[1]);
    $stmt->bindParam(':nombre', $datos[2]);
    $stmt->bindParam(':direccion', $datos[3]);
    $stmt->bindParam(':ubigeo', $datos[4]);
    $stmt->bindParam(':distrito', $datos[5]);
    $stmt->bindParam(':provincia', $datos[6]);
    $stmt->bindParam(':region', $datos[7]);
    $stmt->bindParam(':email', $datos[8]);
    $stmt->bindParam(':perfil', $datos[9], PDO::PARAM_INT);
    $stmt->bindParam(':telefono', $datos[10]);
    $stmt->bindParam(':empresa_id', $datos[11], PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $datos[12], PDO::PARAM_INT);
    $stmt->bindParam(':id_empleado', $datos[13], PDO::PARAM_INT);
    $stmt->bindParam(':estado', $datos[14]);

    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $idEmpleado = $row['id_empleado'];

    $resultado = [];
    if ($datos[14] === "NUEVO") {
        if ($idEmpleado > 0) {
            $resultado = [
                "ESTADO" => "1",
                "ID" => $idEmpleado,
                "MENSAJE" => "LA INFORMACION GUARDO CORRECTAMENTE"
            ];
        } else {
            $resultado = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
            ];
        }
    } else {
        $resultado = [
            "ESTADO" => "1",
            "ID" => $idEmpleado,
            "MENSAJE" => "LA INFORMACION ACTUALIZO CORRECTAMENTE"
        ];
    }

    echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "Error: " . $e->getMessage()
    ]);
}
?>
