<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Incluir conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer el JSON recibido
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Verificar si el JSON es válido
if (json_last_error() !== JSON_ERROR_NONE) {
    error_log("Error al decodificar JSON: " . json_last_error_msg());

    $respuesta = array(
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "Error al decodificar el JSON: " . json_last_error_msg(),
        "RECIBIDO" => $bodyRequest // Muestra el JSON recibido para depuración
    );

    header("HTTP/1.1 400 Bad Request");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);
    exit;
}

try {
    // INICIAR TRANSACCIÓN
    $conn->beginTransaction();

    // Preparar la llamada a la función im_empresa con JSON por claves
    $sql = "SELECT im_empresa(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) AS idempresa";
    $stmt = $conn->prepare($sql);

    // Bind de los parámetros usando claves del JSON
    $stmt->bindParam(1, $datos["cRuc"], PDO::PARAM_STR);
    $stmt->bindParam(2, $datos["cNombre"], PDO::PARAM_STR);
    $stmt->bindParam(3, $datos["cNombreComercial"], PDO::PARAM_STR);
    $stmt->bindParam(4, $datos["cDireccion"], PDO::PARAM_STR);
    $stmt->bindParam(5, $datos["cRepreLegal"], PDO::PARAM_STR);
    $stmt->bindParam(6, $datos["cCodigoSunat"], PDO::PARAM_STR);
    $stmt->bindParam(7, $datos["cUbigeo"], PDO::PARAM_STR);
    $stmt->bindParam(8, $datos["cDistrito"], PDO::PARAM_STR);
    $stmt->bindParam(9, $datos["cProvincia"], PDO::PARAM_STR);
    $stmt->bindParam(10, $datos["cRegion"], PDO::PARAM_STR);
    $stmt->bindParam(11, $datos["cUsuarioSunat"], PDO::PARAM_STR);
    $stmt->bindParam(12, $datos["cClaveSunat"], PDO::PARAM_STR);
    $stmt->bindParam(13, $datos["cClaveCD"], PDO::PARAM_STR);
    $stmt->bindParam(14, $datos["cProceso"], PDO::PARAM_INT);
    $stmt->bindParam(15, $datos["cIdToken"], PDO::PARAM_STR);
    $stmt->bindParam(16, $datos["cClaveToken"], PDO::PARAM_STR);
    $stmt->bindParam(17, $datos["cTipoContribuyente"], PDO::PARAM_INT);
    $stmt->bindParam(18, $datos["cTipoRubro"], PDO::PARAM_INT);
    $stmt->bindParam(19, $datos["cRubro"], PDO::PARAM_STR);
    $stmt->bindParam(20, $datos["cPartida_Registral"], PDO::PARAM_STR);
    $stmt->bindParam(21, $datos["cAutomatico"], PDO::PARAM_BOOL);
    $stmt->bindParam(22, $datos["_cIdEmpM"], PDO::PARAM_INT);
    $stmt->bindParam(23, $datos["_cEstado"], PDO::PARAM_STR);

    // Ejecutar la función
    $stmt->execute();

    // Obtener el resultado
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $idempresa = $resultado['idempresa'];

    // Preparar la respuesta
    if ($idempresa > 0) {
        $conn->commit(); // Confirmar transacción

        $respuesta = array(
            "ESTADO" => "1",
            "ID" => $idempresa,
            "MENSAJE" => "LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE"
        );
    } else {
        $conn->rollBack(); // Revertir transacción si falla

        $respuesta = array(
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
        );
    }

    // Devolver respuesta como JSON
    header("HTTP/1.1 200 OK");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack(); // Revertir en caso de error

    $respuesta = array(
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    );

    header("HTTP/1.1 500 Internal Server Error");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);
} finally {
    $conn = null; // Cerrar conexión
}
?>
