<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// file_put_contents("log_json.txt", $bodyRequest);

if (json_last_error() !== JSON_ERROR_NONE) {
    responder_json(['error' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

// Validar que la clave "activo" exista y sea un booleano
if (!isset($datos['activo']) || !is_bool($datos['activo'])) {
    responder_json(['error' => 'El parámetro "activo" es obligatorio y debe ser booleano (true/false)'], 400);
}

try {
    $activo = $datos['activo'] ? 1 : 0; // Convertimos booleano a 1 o 0

    // Preparar la consulta SQL
    $sql = "SELECT obtener_undmedida(:activo) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
    
    $stmt->execute();

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$resultado) {
        error_log("⚠️ No se encontraron datos con esos filtros.");
    }

    echo $resultado['resultado'];

} catch (PDOException $e) {
    responder_json(['error' => 'Error en la consulta: ' . $e->getMessage()]);
}

function responder_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
?>
