<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input || !isset($input['surtidor_turno_id'])) {
        throw new Exception("Falta el parámetro 'surtidor_turno_id'.");
    }

    $stmt = $conn->prepare("SELECT * FROM cerrar_turno_surtidor(:surtidor_turno_id)");
    $stmt->execute([':surtidor_turno_id' => $input['surtidor_turno_id']]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'estado' => $data['estado'],
        'id' => $data['id'],
        'mensaje' => $data['mensaje']
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
