<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permitir acceso desde cualquier origen
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

// Conexión a PostgreSQL
include_once '../conexion.php';

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar parámetros
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros inválidos: Se requieren empresa_id, sucursal_id y empleado_id.");
    }

    $sql = "SELECT * FROM controlador.listar_despachos(:empresa_id, :sucursal_id, :empleado_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':empleado_id', $datos[2], PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_json($rows);

} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
} finally {
    unset($stmt);
    $conn = null;
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
