<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!is_array($datos) || count($datos) < 4) {
        throw new Exception("Parámetros incompletos.");
    }

    // Inicia la transacción
    $conn->beginTransaction();

    $sql = "SELECT * FROM anular_guiart(:idguia, :anulado, :idempresa, :idsucursal)";
    $stmt = $conn->prepare($sql);

    $stmt->bindParam(':idguia',     $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':anulado',    $datos[1], PDO::PARAM_BOOL);
    $stmt->bindParam(':idempresa',  $datos[2], PDO::PARAM_INT);
    $stmt->bindParam(':idsucursal', $datos[3], PDO::PARAM_INT);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verifica si la función retornó correctamente
    if ($rows && $rows[0]['estado'] === 'OK') {
        $conn->commit();
    } else {
        $conn->rollBack();
        throw new Exception($rows[0]['mensaje'] ?? 'Error al anular la guía.');
    }

    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack(); // Revertir cambios si algo falla
    }
    http_response_code(500);
    echo json_encode(['estado' => 'ERROR', 'mensaje' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
    exit();
}