<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1])) {
        throw new Exception("Parámetros inválidos.");
    }

    $modo = $datos[0];       // '1', '2', '3'
    $filtro1 = $datos[1];    // ejemplo: "C.empresa_id = 1"

    $sql = "SELECT * FROM informe_estadistico(:modo, :filtro1)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':modo', $modo, PDO::PARAM_STR);
    $stmt->bindParam(':filtro1', $filtro1, PDO::PARAM_STR);
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($result, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "Error en la API: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
