<?php
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Error al decodificar JSON: " . json_last_error_msg());
    }

    // Validación más robusta
    if (
        !is_array($datos) ||
        !array_key_exists('filtroInicial', $datos) ||
        !array_key_exists('filtroVenta', $datos) ||
        !array_key_exists('filtroCob', $datos) ||
        !array_key_exists('filtroCaja', $datos) ||
        !array_key_exists('filtroPago', $datos)
    ) {
        throw new Exception("Parámetros inválidos.");
    }

    // Parámetros recibidos
    $filtroInicial = $datos['filtroInicial'];
    $filtroVenta   = $datos['filtroVenta'];
    $filtroCob     = $datos['filtroCob'];
    $filtroCaja    = $datos['filtroCaja'];
    $filtroPago    = $datos['filtroPago'];

    // Llamada a la función actualizada
    $sql = "SELECT liquidacion_caja(:filtroInicial, :filtroVenta, :filtroCob, :filtroCaja, :filtroPago) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtroInicial', $filtroInicial, PDO::PARAM_STR);
    $stmt->bindParam(':filtroVenta',   $filtroVenta,   PDO::PARAM_STR);
    $stmt->bindParam(':filtroCob',     $filtroCob,     PDO::PARAM_STR);
    $stmt->bindParam(':filtroCaja',    $filtroCaja,    PDO::PARAM_STR);
    $stmt->bindParam(':filtroPago',    $filtroPago,    PDO::PARAM_STR);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row || !$row['resultado']) {
        throw new Exception("No se obtuvo respuesta de la función.");
    }

    echo $row['resultado'];

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "Error en la API: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
