<?php
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Error al decodificar JSON: " . json_last_error_msg());
    }

    // Validación de parámetros requeridos
    if (
        !is_array($datos) ||
        !array_key_exists('filtroInicial', $datos) ||
        !array_key_exists('filtro', $datos)
    ) {
        throw new Exception("Parámetros insuficientes.");
    }

    // Asignación de variables
    $filtroInicial = $datos['filtroInicial'];
    $filtro        = $datos['filtro'];

    // Llamada a la función resumen_caja
    $sql = "SELECT movimiento_caja(:filtroInicial, :filtro) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtroInicial', $filtroInicial, PDO::PARAM_STR);
    $stmt->bindParam(':filtro',        $filtro,        PDO::PARAM_STR);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row || !$row['resultado']) {
        throw new Exception("No se obtuvo respuesta de la función.");
    }

    echo $row['resultado'];

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "Error en la API: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
