<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php'; 
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer y decodificar el cuerpo JSON
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    //file_put_contents("debug_stock_log.txt", $bodyRequest);

    // Validamos que lleguen los dos parámetros esperados
    if (!is_array($datos) || count($datos) < 2) {
        throw new Exception("Faltan condiciones para los filtros WHERE y HAVING");
    }

    $filtroTemp = $datos[0];   // Para el WHERE de la tabla temporal
    $filtroFinal = $datos[1];  // Para el HAVING final

    // Consulta a la función PostgreSQL
    $sql = "SELECT * FROM informe_stock(:filtro_temp, :filtro_final)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtro_temp', $filtroTemp, PDO::PARAM_STR);
    $stmt->bindParam(':filtro_final', $filtroFinal, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // ✅ Si no hay resultados, devolver un array vacío
    echo json_encode($rows ?: [], JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    error_response("Error en la base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
}

// Función de error estructurada
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
