<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode( file_get_contents( 'php://input' ), true );

// Iniciar la transacción
mysqli_autocommit( $conn, false );
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = '';

try {
    // Acceder a los valores individuales de los datos combinados
    $cFecha = $data[ 'Fecha' ];
    $cNombre = $data[ 'Nombre' ];
    $cDireccion = $data[ 'Direccion' ];
    $cDocIdentidad = $data[ 'DocIdentidad' ];
    $cMoneda = $data[ 'Moneda' ];
    $cTipoCambio = $data[ 'Tipo_Cambio' ];
    $cProveedor_Id = $data[ 'Proveedor_Id' ];
    $cSucursal_Id = $data[ 'Sucursal_Id' ];
    $cEmpresa_Id = $data[ 'Empresa_Id' ];
    $cEstado = $data[ 'Estado' ];

        // Ejemplo de inserción en la tabla Pagos
        $queryLetra = "INSERT INTO canje_letrasxpagar(fecha, moneda, tipo_cambio, proveedor_id, sucursal_id, empresa_id)
        VALUES('$cFecha', '$cMoneda', '$cTipoCambio', '$cProveedor_Id', '$cSucursal_Id', '$cEmpresa_Id')";

        $resultadoLetra = mysqli_query( $conn, $queryLetra );
        if ( !$resultadoLetra ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // Obtener el ID del último registro insertado en el Movimiento de Letras
        $idMovLetra = mysqli_insert_id( $conn );
        
        // Actualiza Documentos que son Canjeados
        foreach ( $data[ 'creditos_canjeados' ] as $creditos_canjeados_ ) {
            $idcompra = $creditos_canjeados_['compra_id'];
            
            $queryLetraUPD = "UPDATE creditos_pagar SET canjeado = 1, letra = 1, letra_id = '$idMovLetra' WHERE proveedor_id = $cProveedor_Id AND compra_id = $idcompra";
    
            $resultadoLetraUPD = mysqli_query( $conn, $queryLetraUPD );
            if ( !$resultadoLetraUPD ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }

        // Ejemplo de inserción en la tabla detalle
        foreach ( $data[ 'detalle' ] as $detalle_ ) {
            $cNSerie = $detalle_[ 'nserie' ];
            $cNDocumento = $detalle_[ 'ndocumento' ];
            $cNLetra = $detalle_[ 'nro_letra' ];
            $cNUnico = $detalle_[ 'nro_unico' ];
            $cFecha_Emi = $detalle_[ 'fecha' ];
            $cFecha_Venc = $detalle_[ 'fecha_vencimiento' ];
            $cDeuda_Soles = $detalle_[ 'deuda_soles' ];
            $cDeuda_Dolar = $detalle_[ 'deuda_dolar' ];
            $idcompra = $detalle_[ 'compra_id' ];
            
            $queryCreditosxPag = "INSERT INTO creditos_pagar(nserie, ndocumento, nro_letra, nro_unico, fecha, fecha_vencimiento, documento_identidad, 
                razon_social, direccion, deuda_soles, deuda_dolar, moneda, tipo_cambio, proveedor_id, compra_id, sucursal_id, empresa_id)
                VALUES('$cNSerie', '$cNDocumento', '$cNSerie', '$cNDocumento', '$cFecha', '$cFecha_Venc', '$cDocIdentidad', '$cNombre', '$cDireccion',
                '$cDeuda_Soles', '$cDeuda_Dolar', '$cMoneda', '$cTipoCambio', '$cProveedor_Id', '$idcompra', '$cSucursal_Id','$cEmpresa_Id')"; 

            $resultadoCreditosxPag = mysqli_query($conn, $queryCreditosxPag);
            if (!$resultadoCreditosxPag) {
                throw new Exception(mysqli_error($conn));
            }    

        }
        

    // Confirmar la transacción
    mysqli_commit( $conn );

} catch ( Exception $e ) {
    // Revertir la transacción en caso de error
    mysqli_rollback( $conn );
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close( $conn );

// Enviar una respuesta al cliente
if ( $transaccionExitosa ) {
    $response = array();
    //$response = array( 'ESTADO' => '00', 'MENSAJE' => 'Los datos se han guardado correctamente' );

        if ( $idMovLetra > 0 ) {
            //$response = array();
            $response[ 'ESTADO' ] = '00';
            $response[ 'ID' ] = $idMovLetra;
            $response[ 'MENSAJE' ] = 'Los datos se han guardado correctamente';
        } else {
            //$response = array();
            $response[ 'ESTADO' ] = '11';
            $response[ 'ID' ] = 0;
            $response[ 'MENSAJE' ] = 'Error al guardar la información: ' . $errorMensaje;
        }
    
} else {
    //$response = array( 'ESTADO' => '11', 'MENSAJE' => 'Error al guardar la información: ' . $errorMensaje );
    $response = array();
    $response[ 'ESTADO' ] = '111';
    $response[ 'ID' ] = 0;
    $response[ 'MENSAJE' ] = 'Error al guardar la información: ' . $errorMensaje;
}
echo json_encode( $response );

?>