<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    responder_json(['error' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

// file_put_contents("log_json.txt", file_get_contents("php://input"));

try {
    $ventaId = $datos[0] ?? null;
    $param1 = $datos[1] ?? '';
    $param2 = $datos[2] ?? '';
    $param3 = $datos[3] ?? '';
    
    $sql = "SELECT obtener_cabecera_nc_clte(:venta_id, :param1, :param2, :param3) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':venta_id', $ventaId, PDO::PARAM_INT);
    $stmt->bindParam(':param1', $param1, PDO::PARAM_INT);
    $stmt->bindParam(':param2', $param2, PDO::PARAM_INT);
    $stmt->bindParam(':param3', $param3, PDO::PARAM_INT);
    
    $stmt->execute();

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$resultado) {
        error_log("⚠️ No se encontraron datos con esos filtros.");
    }

    echo $resultado['resultado'];

} catch (PDOException $e) {
    responder_json(['error' => 'Error en la consulta: ' . $e->getMessage()]);
}

function responder_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
?>
