<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php'; 
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = [];

try {
    if (!isset($datos[0])) {
        throw new Exception("ID de venta no proporcionado.");
    }

    $venta_id = $datos[0];

    $sql = "SELECT 
                ((deuda_soles + interes_soles) - pago_soles) AS Deuda_Soles, 
                ((deuda_dolar + interes_dolar) - pago_dolar) AS Deuda_Dolar 
            FROM creditos_cobrar 
            WHERE venta_id = :venta_id 
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':venta_id', $venta_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } else {
        $rows = [];
    }

    print_json($rows);

} catch (Exception $e) {
    error_response("ERROR: " . $e->getMessage());
}

// FUNCIONES DE RESPUESTA

function print_json($data) {
    $json = json_encode($data, JSON_UNESCAPED_UNICODE);
    if ($json === false) {
        error_response('Error al codificar JSON: ' . json_last_error_msg());
    }
    echo $json;
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>