<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar JSON recibido
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        print_json(['error' => 'JSON inválido', 'detalle' => json_last_error_msg()]);
        exit();
    }

    // Validar existencia y tipo del parámetro
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        http_response_code(400);
        print_json(['error' => 'Entrada inválida. Se esperaba un arreglo con un ID numérico.']);
        exit();
    }

    $param1 = intval($datos[0]);

    // Consulta segura usando función PostgreSQL
    $sql = "SELECT * FROM Consultar_NotaProv_Id(:param1)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':param1', $param1, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        error_log("⚠️ No se encontraron resultados para Consultar_NotaProv_Id con ID: $param1");
    }

    print_json($rows);

} catch (PDOException $e) {
    error_log("❌ Error en la base de datos: " . $e->getMessage());
    http_response_code(500);
    print_json(['error' => 'Error en la base de datos', 'detalle' => $e->getMessage()]);
} catch (Exception $e) {
    error_log("❌ Error inesperado: " . $e->getMessage());
    http_response_code(500);
    print_json(['error' => 'Error inesperado', 'detalle' => $e->getMessage()]);
} finally {
    $conn = null;
}

// Función robusta para imprimir JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("❌ Error al codificar JSON: " . json_last_error_msg());
    }
}
?>
