<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL Eliminar_NotaProv(?,?,?,?)");
$sql->bind_param("iiii", ...$datos);

$sql->execute();

$rowsAffected = $sql->affected_rows;

if ($rowsAffected > 0) {
    // Se insertó o actualizó al menos un registro
    print_json(array('ESTADO' => '1', 'MENSAJE' => 'Registro Eliminado con éxito'));
} else {
    // No se insertó ni actualizó ningún registro
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'No se pudo Eliminar el Registro de la base de datos'));
}

// Devolver la respuesta JSON
//print_json($resultado);

// Cerrar la conexi¨®n a la base de datos
mysqli_close($conn);

function print_json($data) {
    header("HTTP/1.1");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>
