<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if ($data === null || json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode([
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "JSON inválido: " . json_last_error_msg()
        ]);
        exit;
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'.");
    }

    $conn->beginTransaction();

    // Validar campos requeridos
    $requiredFields = [
        'Empresa_id', 'DocFiscal_Id', 'NSerie', 'NDocumento', 'Fecha_Emision', 'Fecha_Traslado',
        'Fecha_Vcto', 'Razon_Social', 'Direccion', 'Tipo_Documento', 'DocIdentidad', 'NDias',
        'Moneda', 'Tipo_Cambio', 'Afecto_IGV', 'pIGV', 'IGV', 'Afecto_Dscto', 'pDSCTO',
        'Descuento', 'Afecto_Percepcion', 'pPercepcion', 'Percepcion', 'Valor_Compra',
        'Inafecto', 'Exonerada', 'Total_Pagar', 'NGuiaRemision', 'Cancelado', 'ICBPER',
        'Gratuitas', 'Afecta_Kardex', 'Afecta_Caja', 'Periodo', 'Mes', 'Forma_Pago',
        'Caja_Id', 'Proveedor_Id', 'Sucursal_Id', 'Observacion', 'MotivoNota',
        'DocFiscal_Ref', 'NSerie_Ref', 'Documento_Ref', 'Fecha_EmisionRef', 'Id_CmpRef',
        'Almacen_Id', 'IdCmp_M', 'Estado', 'detalle'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($data[$field])) {
            echo json_encode([
                'ESTADO' => '0',
                'ID' => '0',
                'MENSAJE' => "Falta el campo '$field'."
            ]);
            http_response_code(400);
            exit();
        }
    }

    // Llamar a la función PostgreSQL
    $sql = "SELECT procesar_notacred_prov(
        :p_empresa_id, :p_docfiscal_id, :p_nserie, :p_ndocumento, :p_fecha_emision, :p_fecha_traslado, :p_fecha_vencimiento,
        :p_nombre, :p_direccion, :p_tipdocident, :p_docidentidad, :p_ndias, :p_moneda, :p_tipo_cambio, :p_afecto_igv, 
        :p_pigv, :p_igv, :p_afect_dscto, :p_pdscto, :p_descuento, :p_afecto_percepcion, :p_ppercepcion, :p_percepcion,
        :p_valor_compra, :p_inafecto, :p_exonerado, :p_total, :p_guia_remision, :p_cancelado, :p_icbp, :p_gratuitas, 
        :p_afecta_kardex, :p_afecta_caja, :p_periodo, :p_mes, :p_forma_pago_id, :p_caja_id, :p_proveedor_id, 
        :p_sucursal_id, :p_observacion, :p_motivo_nota, :p_docfiscal_ref, :p_nserie_ref, :p_documento_ref, 
        :p_fecha_emisionref, :p_idcmpref, :p_almacen_id, :p_idcmp_m, :p_estado, :p_detalle
    ) AS id_nota";

    $stmt = $conn->prepare($sql);

    // Asignar los valores
    $stmt->bindValue(':p_empresa_id', $data['Empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_id', $data['DocFiscal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie', $data['NSerie']);
    $stmt->bindValue(':p_ndocumento', $data['NDocumento']);
    $stmt->bindValue(':p_fecha_emision', $data['Fecha_Emision']);
    $stmt->bindValue(':p_fecha_traslado', $data['Fecha_Traslado']);
    $stmt->bindValue(':p_fecha_vencimiento', $data['Fecha_Vcto']);
    $stmt->bindValue(':p_nombre', $data['Razon_Social']);
    $stmt->bindValue(':p_direccion', $data['Direccion']);
    $stmt->bindValue(':p_tipdocident', $data['Tipo_Documento']);
    $stmt->bindValue(':p_docidentidad', $data['DocIdentidad']);
    $stmt->bindValue(':p_ndias', $data['NDias']);
    $stmt->bindValue(':p_moneda', $data['Moneda']);
    $stmt->bindValue(':p_tipo_cambio', $data['Tipo_Cambio']);
    $stmt->bindValue(':p_afecto_igv', filter_var($data['Afecto_IGV'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pigv', $data['pIGV']);
    $stmt->bindValue(':p_igv', $data['IGV']);
    $stmt->bindValue(':p_afect_dscto', filter_var($data['Afecto_Dscto'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pdscto', $data['pDSCTO']);
    $stmt->bindValue(':p_descuento', $data['Descuento']);
    $stmt->bindValue(':p_afecto_percepcion', filter_var($data['Afecto_Percepcion'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_ppercepcion', $data['pPercepcion']);
    $stmt->bindValue(':p_percepcion', $data['Percepcion']);
    $stmt->bindValue(':p_valor_compra', $data['Valor_Compra']);
    $stmt->bindValue(':p_inafecto', $data['Inafecto']);
    $stmt->bindValue(':p_exonerado', $data['Exonerada']);
    $stmt->bindValue(':p_total', $data['Total_Pagar']);
    $stmt->bindValue(':p_guia_remision', $data['NGuiaRemision']);
    $stmt->bindValue(':p_cancelado', $data['Cancelado'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_icbp', $data['ICBPER']);
    $stmt->bindValue(':p_gratuitas', $data['Gratuitas']);
    $stmt->bindValue(':p_afecta_kardex', filter_var($data['Afecta_Kardex'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_afecta_caja', filter_var($data['Afecta_Caja'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_periodo', $data['Periodo']);
    $stmt->bindValue(':p_mes', $data['Mes']);
    $stmt->bindValue(':p_forma_pago_id', $data['Forma_Pago'], PDO::PARAM_INT);
    $stmt->bindValue(':p_caja_id', $data['Caja_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_proveedor_id', $data['Proveedor_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id', $data['Sucursal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_observacion', $data['Observacion']);
    $stmt->bindValue(':p_motivo_nota', $data['MotivoNota'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_ref', $data['DocFiscal_Ref'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie_ref', $data['NSerie_Ref']);
    $stmt->bindValue(':p_documento_ref', $data['Documento_Ref']);
    $stmt->bindValue(':p_fecha_emisionref', $data['Fecha_EmisionRef']);
    $stmt->bindValue(':p_idcmpref', $data['Id_CmpRef'], PDO::PARAM_INT);
    $stmt->bindValue(':p_almacen_id', $data['Almacen_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_idcmp_m', $data['IdCmp_M'], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado', $data['Estado']);
    $stmt->bindValue(':p_detalle', json_encode($data['detalle']), PDO::PARAM_STR);

    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $id_nota = $resultado['id_nota'];

    $conn->commit();

    echo json_encode([
        "ESTADO" => $id_nota > 0 ? "1" : "0",
        "ID" => $id_nota ?: 0,
        "MENSAJE" => $id_nota > 0 ? "NOTA PROCESADA CORRECTAMENTE" : "ERROR AL REGISTRAR LA NOTA"
    ]);

} catch (PDOException $e) {
    $conn->rollBack();
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ]);
} finally {
    $conn = null;
}
?>
