<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye la conexión PDO con PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar datos
if (!isset($datos[0], $datos[1])) {
    http_response_code(400);
    echo json_encode(['error' => 'Parámetros inválidos']);
    exit;
}

$idEmpresa = (int)$datos[0];
$nombre = trim($datos[1]);

try {
    $sql = "SELECT nombre FROM operaciones_caja WHERE empresa_id = :empresa_id AND nombre = :nombre LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $idEmpresa, PDO::PARAM_INT);
    $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Error en la consulta',
        'detalle' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
