<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0]) || !isset($datos[1])) {
        throw new Exception("Parámetros incompletos. Se requieren usuario_id y activo.");
    }

    // Convertimos los parámetros
    $usuario_id = (int) $datos[0];
    $activo = filter_var($datos[1], FILTER_VALIDATE_BOOLEAN);

    // Llamamos al procedimiento almacenado
    $sql = "CALL activa_todos_dialogos(:usuario_id, :activo)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);
    $stmt->execute();

    // Como es un procedimiento sin retorno, asumimos que fue exitoso
    $resultado = [
        "estado" => "1",
        "mensaje" => "Los permisos fueron actualizados correctamente."
    ];

    echo json_encode($resultado, JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "0",
        "mensaje" => "Error: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>
