<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Se incluye el archivo que contiene la conexión a la base de datos PostgreSQL con PDO
include_once '../conexion.php';

// Obtener el cuerpo de la solicitud y decodificarlo
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = array();

try {
    // Parámetros del procedimiento almacenado
    $param1 = $datos[0]; // Primer parámetro (string)
    $param2 = $datos[1]; // Segundo parámetro (string)
    $param3 = $datos[2]; // Tercer parámetro (integer)
    $param4 = $datos[3]; // Cuarto parámetro (integer)

    // Llamada al procedimiento almacenado
    $sql = "SELECT * FROM Dashort(:param1, :param2, :param3, :param4)";

    // Preparar la sentencia
    $stmt = $conn->prepare($sql);

    // Vincular parámetros
    $stmt->bindParam(':param1', $param1, PDO::PARAM_STR);
    $stmt->bindParam(':param2', $param2, PDO::PARAM_STR);
    $stmt->bindParam(':param3', $param3, PDO::PARAM_INT);
    $stmt->bindParam(':param4', $param4, PDO::PARAM_INT);

    // Ejecutar la sentencia
    $stmt->execute();

    // Obtener los resultados
    if ($stmt->rowCount() > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $rows[] = $row;
        }
    } else {
        echo "No records matching your query were found.";
    }
} catch (PDOException $e) {
    echo "ERROR: Could not able to execute the query. " . $e->getMessage();
}

// Cerrar la conexión a la base de datos (opcional, ya que PDO la cierra automáticamente al final del script)
$conn = null;

// Imprimir la respuesta en formato JSON
print_json($rows);

// Función para imprimir JSON y manejar errores de codificación
function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
    }
}
?>