<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8"); // Asegurar que el encabezado se envíe antes de cualquier salida

// Se incluye el archivo que contiene la conexión a la base de datos PostgreSQL con PDO
include_once '../conexion.php'; // Asegúrate de que este archivo configure la conexión a PostgreSQL usando PDO

// Obtener el cuerpo de la solicitud y decodificarlo
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = array();

try {
    // Parámetros del procedimiento almacenado
    $param1 = $datos[0]; // Primer parámetro (string)
    $param2 = $datos[1]; // Segundo parámetro (string)
    $param3 = $datos[2]; // Tercer parámetro (integer)
    $param4 = $datos[3]; // Cuarto parámetro (integer)

    // Llamada al procedimiento almacenado
    $sql = "SELECT egresos_mensuales AS total_egresos FROM Egresos_Mensuales(:param1, :param2, :param3, :param4)";

    // Preparar la sentencia
    $stmt = $conn->prepare($sql);

    // Vincular parámetros
    $stmt->bindParam(':param1', $param1, PDO::PARAM_STR);
    $stmt->bindParam(':param2', $param2, PDO::PARAM_STR);
    $stmt->bindParam(':param3', $param3, PDO::PARAM_INT);
    $stmt->bindParam(':param4', $param4, PDO::PARAM_INT);

    // Ejecutar la sentencia
    $stmt->execute();
	
    // Obtener los resultados
    if ($stmt->rowCount() > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $rows[] = $row;
        }
    } else {
        // Si no se encuentran registros, devolver un array vacío
        $rows[] = ["total_egresos" => 0];
    }
} catch (PDOException $e) {
    error_response("ERROR en la consulta: " . $e->getMessage());
}

// Cerrar la conexión a la base de datos (opcional, ya que PDO la cierra automáticamente al final del script)
$conn = null;

echo json_encode($rows, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
exit();

// Imprimir la respuesta en formato JSON
print_json($rows);

// Función para imprimir JSON y manejar errores de codificación
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Máxima profundidad de pila excedida');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Desbordamiento o desajuste de modos');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Caracter de control inesperado encontrado');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Error de sintaxis, JSON mal formado');
            break;
        case JSON_ERROR_UTF8:
            error_response('Caracteres UTF-8 mal formados, posiblemente codificados incorrectamente');
            break;
        default:
            error_response('Error desconocido');
            break;
    }
}

// Función para responder con error en JSON
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>