<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir la conexión a PostgreSQL
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar que se envíen los parámetros requeridos
if (!isset($datos[0]) || !isset($datos[1])) {
    error_response("Parámetros inválidos.");
}

try {
    // Llamada al procedimiento almacenado en PostgreSQL
    $sql = "SELECT * FROM Stock_Precios_Excel(:param1, :param2)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':param1', $datos[0], PDO::PARAM_STR);
    $stmt->bindParam(':param2', $datos[1], PDO::PARAM_INT);
    $stmt->execute();

    // Obtener el resultado
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Enviar la respuesta en JSON
    print_json($rows ?: []);

} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
}

// Cerrar la conexión
$conn = null;

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
