<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo de conexin
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = [];

try {
    // Consulta adaptada a PostgreSQL
    $sql = "SELECT C.*, CU.usuario_id FROM cajas AS C 
            INNER JOIN caja_usuario AS CU ON C.id = CU.caja_id
            WHERE C.empresa_id = :empresa_id 
              AND CU.usuario_id = :usuario_id 
              AND C.activo = TRUE 
            ORDER BY CU.principal DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':usuario_id', $datos[1], PDO::PARAM_INT);

    // Ejecutar la consulta
    $stmt->execute();
    
    // Obtener resultados
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
}

// Cerrar la conexin
$conn = null;

// Imprimir la respuesta en formato JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>