<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Obtener datos del cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0]) || !isset($datos[1])) {
        throw new Exception("Los parámetros 'id' y 'principal' son obligatorios.");
    }

    // Preparar la consulta en PostgreSQL
    $sql = "UPDATE almacenes SET principal = :principal WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':principal', $datos[1], PDO::PARAM_INT);
    $stmt->bindParam(':id', $datos[0], PDO::PARAM_INT);
    $stmt->execute();

    // Verificar si se actualizaron filas
    if ($stmt->rowCount() > 0) {
        $response = [
            'status' => 'success',
            'message' => 'Actualización exitosa.'
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'No se pudo actualizar el registro o no hubo cambios.'
        ];
    }

    // Cerrar statement
    $stmt = null;

} catch (Exception $e) {
    $response = [
        'status' => 'error',
        'message' => $e->getMessage()
    ];
}

// Devolver respuesta JSON
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>
