<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Parámetros incompletos. Se requieren 3 valores.");
    }

    $sql = "SELECT jala_secuencia(:cfecha, :csigla, :cempresa_id) AS numero_envio";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':cfecha',      $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':csigla',      $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':cempresa_id', $datos[2], PDO::PARAM_INT);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result && isset($result['numero_envio'])) {
        // ✅ solo devuelve lo que Java necesita
        echo json_encode([
            "numero_envio" => (int)$result['numero_envio']
        ], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode([
            "numero_envio" => 0
        ], JSON_UNESCAPED_UNICODE);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}