<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!is_array($datos) || count($datos) < 9) {
        throw new Exception("Parámetros incompletos.");
    }

    // Iniciar la transacción
    $conn->beginTransaction();

    $sql = "SELECT * FROM anular_venta(:idventa, :anulado, :afecto, :exonerado, :igv, :total, :idempresa, :idsucursal, :iddespacho)";
    $stmt = $conn->prepare($sql);

    $stmt->bindParam(':idventa', $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':anulado', $datos[1], PDO::PARAM_BOOL);
    $stmt->bindParam(':afecto', $datos[2]);
    $stmt->bindParam(':exonerado', $datos[3]);
    $stmt->bindParam(':igv', $datos[4]);
    $stmt->bindParam(':total', $datos[5]);
    $stmt->bindParam(':idempresa', $datos[6], PDO::PARAM_INT);
    $stmt->bindParam(':idsucursal', $datos[7], PDO::PARAM_INT);
    $stmt->bindParam(':iddespacho', $datos[8], PDO::PARAM_INT);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Validar resultado antes de confirmar
    if ($rows && $rows[0]['estado'] === 'OK') {
        $conn->commit();
    } else {
        $conn->rollBack();
        throw new Exception($rows[0]['mensaje'] ?? 'Error en anulación de venta.');
    }

    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack(); // Revertir cambios si hay error
    }
    http_response_code(500);
    echo json_encode(['estado' => 'ERROR', 'mensaje' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
