<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Se incluye la conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Obtener el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400); // Bad Request
    print_json(['error' => 'Invalid JSON']);
    exit();
}

// Validar y sanitizar los datos recibidos
if (!isset($datos[0]) || !is_string($datos[0]) || 
    !isset($datos[1]) || !is_numeric($datos[1]) || 
    !isset($datos[2]) || !is_numeric($datos[2])) {
    http_response_code(400); // Bad Request
    print_json(['error' => 'Invalid input']);
    exit();
}

$param1 = trim($datos[0]);
$param2 = (int) $datos[1];
$param3 = (int) $datos[2];

try {
    $sql = "SELECT * FROM Llamar_ClteEventual(:param1, :param2, :param3)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':param1', $param1, PDO::PARAM_STR);
    $stmt->bindParam(':param2', $param2, PDO::PARAM_INT);
    $stmt->bindParam(':param3', $param3, PDO::PARAM_INT);
    $stmt->execute();
    
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (!$rows) {
        error_log("⚠️ No se encontraron compras con esos filtros.");
    }
    
    print_json($rows);
} catch (PDOException $e) {
    http_response_code(500); // Internal Server Error
    print_json(['error' => 'Query execution failed', 'details' => $e->getMessage()]);
    error_log("❌ Error en la consulta: " . $e->getMessage());
}

function print_json($data) {
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}