<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar el JSON recibido
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        print_json(['error' => 'JSON inválido', 'detalle' => json_last_error_msg()]);
        exit();
    }

    // Validar la entrada
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        http_response_code(400);
        print_json(['error' => 'Entrada inválida']);
        exit();
    }

    $param1 = intval($datos[0]); // Convertir a entero seguro

    $sql = "SELECT * FROM Consultar_Venta_Id(:param1)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':param1', $param1, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$rows) {
        error_log("⚠️ No se encontraron ventas con esos filtros.");
    }

    print_json($rows);

} catch (PDOException $e) {
    error_log("❌ Error en la base de datos: " . $e->getMessage());
    http_response_code(500);
    print_json(['error' => 'Error en la base de datos', 'detalle' => $e->getMessage()]);
} catch (Exception $e) {
    error_log("❌ Error general: " . $e->getMessage());
    http_response_code(500);
    print_json(['error' => 'Error inesperado', 'detalle' => $e->getMessage()]);
} finally {
    $conn = null; // Cerrar la conexión
}

// Función para imprimir JSON con validación
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("❌ Error al codificar JSON: " . json_last_error_msg());
    }
}
?>
