<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    // Llamada a la función PostgreSQL que devuelve registros
    $stmt = $conn->prepare("SELECT * FROM Listar_SalidaSeries(:id_salida, :codigo_producto, :empresa_id)");
    $stmt->bindValue(':id_salida', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':codigo_producto', $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':empresa_id', $datos[2], PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_json($rows ?: []);
} catch (PDOException $e) {
    error_response("Error en la base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response($e->getMessage());
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH: error_response('Maximum stack depth exceeded'); break;
        case JSON_ERROR_STATE_MISMATCH: error_response('Underflow or the modes mismatch'); break;
        case JSON_ERROR_CTRL_CHAR: error_response('Unexpected control character found'); break;
        case JSON_ERROR_SYNTAX: error_response('Syntax error, malformed JSON'); break;
        case JSON_ERROR_UTF8: error_response('Malformed UTF-8 characters, possibly incorrectly encoded'); break;
        default: error_response('Unknown error'); break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>